package it.eng.eremita.jpa.entity;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import io.leangen.graphql.annotations.GraphQLQuery;

@Entity
@Table(name="EREMITA_SITI_N2000")
public class SitoNatura2000 implements Serializable {
	
	String id;
	String tipo;
	String nome;
	
	@Id
	@Column(name="ID")
	@GraphQLQuery(name="id")
	public String getId() {
		return id;
	}
	public void setId(String id) {
		this.id = id;
	}
	
	@Column(name="TIPO")
	@GraphQLQuery(name="tipo")
	public String getTipo() {
		return tipo;
	}
	public void setTipo(String tipo) {
		this.tipo = tipo;
	}
	
	@Column(name="NOME")
	@GraphQLQuery(name="nome")
	public String getNome() {
		return nome;
	}
	public void setNome(String nome) {
		this.nome = nome;
	}
	
	public boolean equals(Object o) {
		if (o==null) return false;
		
		if (!(o instanceof SitoNatura2000)) return false;
		
		SitoNatura2000 ms = (SitoNatura2000)o;
		if (ms.getId()==this.getId()) return true;
		if (ms.getId()==null) return false;
		return (ms.getId().equals(this.getId()));

	}
	
	@Override
	public String toString() {
		return "SitoNatura2000-"+getId();
	}
	
	@Override
	public int hashCode() {
		return (getId()!=null?getId().hashCode():0 );
	}
	

}
